//
//  YHTravelCertificateItemView.swift
//  galaxy
//
//  Created by edy on 2024/8/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHTravelCertificateItemView: UIView {
    
    var titleMaxWidth = 112.0
    
    var clickBlock: (() -> Void)?
    
    var title: ASAttributedString = "" {
        didSet {
            titleLabel.attributed.text = title
        }
    }
    
    var placeHolder: String = ""
    
    var errorTips: String = "" {
        didSet {
            errorLabel.text = errorTips
        }
    }
    
    var isNeedShowErrorTips: Bool = false {
        didSet {
            errorLabel.isHidden = !isNeedShowErrorTips
            errorLabel.snp.remakeConstraints { make in
                make.top.equalTo(detailLabel.snp.bottom).offset(isNeedShowErrorTips ? 5 : 0)
                make.left.equalTo(titleLabel)
                make.right.equalTo(0)
                make.bottom.equalTo(-16)
                if !isNeedShowErrorTips {
                    make.height.equalTo(0)
                }
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
        
    }
    var detail: String = "" {
        didSet {
            
            if detail.isEmpty {
                // 显示placeHolder
                detailLabel.text = self.placeHolder
                detailLabel.textColor = .placeHolderColor
                detailLabel.textAlignment = .left
                self.setNeedsLayout()
                self.layoutIfNeeded()
                return
            }
            detailLabel.text = detail
            detailLabel.textColor = .mainTextColor
            detailLabel.textAlignment = .left
            
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
       
    }
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var errorLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = .failColor
        return label
    }()
    
    lazy var arrowImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "family_info_arrow"))
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
     
    @objc func didSelectView() {
        clickBlock?()
    }
    
    func createUI() {
        self.addSubview(titleLabel)
        self.addSubview(detailLabel)
        self.addSubview(arrowImgView)
        self.addSubview(lineView)
        self.addSubview(errorLabel)
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(didSelectView))
        self.addGestureRecognizer(tap)

        lineView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(0)
            make.height.equalTo(0.5)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(16)
            make.width.equalTo(titleMaxWidth)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(titleLabel.snp.right)
            make.right.equalTo(arrowImgView.snp.left)
        }
        
        errorLabel.snp.makeConstraints { make in
            make.top.equalTo(detailLabel.snp.bottom).offset(0)
            make.left.equalTo(titleLabel)
            make.right.equalTo(0)
            make.bottom.equalTo(-16)
        }
        
        arrowImgView.snp.makeConstraints { make in
            make.width.height.equalTo(22)
            make.top.equalTo(15)
            make.right.equalTo(0)
        }
    }
}
